// content.js - 最终完整版 (含UID修复 + BD展示 + 状态记忆)

// 1. 获取 UID (视频页/主页通用)
function getTikTokUID() {
    let jsonData = null;
    try {
        const script = document.getElementById('__UNIVERSAL_DATA_FOR_REHYDRATION__');
        if (script) jsonData = JSON.parse(script.textContent);
    } catch (e) {}

    if (jsonData) {
        const defaultScope = jsonData.__DEFAULT_SCOPE__;
        if (defaultScope) {
            if (defaultScope['webapp.user-detail']) {
                try { return defaultScope['webapp.user-detail'].userInfo.user.id; } catch (e) {}
            }
            if (defaultScope['webapp.video-detail']) {
                try { return defaultScope['webapp.video-detail'].itemInfo.itemStruct.author.id; } catch (e) {}
            }
        }
    }
    const html = document.body.innerHTML;
    const matchAuthor = html.match(/"authorId":"(\d+)"/);
    if (matchAuthor) return matchAuthor[1];
    const matchOwner = html.match(/"ownerId":"(\d+)"/);
    if (matchOwner) return matchOwner[1];
    return null;
}

// 2. 主逻辑
function init() {
    const handle = window.location.pathname.split('/')[1];
    if (handle && handle.startsWith('@')) {
        setTimeout(() => {
            const uid = getTikTokUID();
            if (uid) {
                fetchData(uid, handle); 
            } else {
                showPanel({ found: false }, handle, "UID失败");
            }
        }, 1500);
    }
}

// 3. 请求数据
function fetchData(uid, handle) {
    const cleanHandle = handle.replace('@', '');
    const apiUrl = `https://tiktokusapi.onrender.com/api/check?uid=${uid}&handle=${cleanHandle}`;

    fetch(apiUrl)
        .then(res => res.json())
        .then(data => showPanel(data, handle, uid))
        .catch(err => console.error(err));
}

// 4. 显示面板 (核心修改区域)
function showPanel(data, handle, uid) {
    const existing = document.getElementById('gmv-panel');
    if (existing) existing.remove();

    const div = document.createElement('div');
    div.id = 'gmv-panel';

    // ▼▼▼▼▼ 关键点 1：读取记忆的状态 ▼▼▼▼▼
    // 检查浏览器是否存了 "我被缩小了" 的标记
    const isMinimized = localStorage.getItem('gmvPanelMinimized') === 'true';
    if (isMinimized) {
        // 如果存了，直接加上缩小的类
        div.classList.add('minimized');
    }
    // ▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲

    
    // --- 数据处理 ---
    const rawGmv = data.gmv || data['30天总GMV'];
    const gmvDisplay = rawGmv ? parseFloat(rawGmv).toLocaleString() : '0';
    const rawRatio = data.ratio || data['主要占比'];
    const ratioDisplay = rawRatio ? (parseFloat(rawRatio) * 100).toFixed(1) + '%' : 'N/A';
    const bdDisplay = data.bd_manager || '未分配';
    const contactDisplay = data.contact || data['email'] || '暂无';
    const levelDisplay = data.level || data['当前等级'] || '-';
    const ageDisplay = data.age || data['主要年龄层'] || '-';

    // --- 构建 HTML (更新了Header结构) ---
    let innerContent = '';
    // 使用更清晰的减号符号
    const minimizeBtnHtml = `<div id="minimize-btn" class="minimize-btn" title="收起">−</div>`;
    
    if (data.found) {
        innerContent = `
            <div class="full-content">
                <div class="gmv-header">
                    <div class="header-left">
                        <div class="status-badge success">✅ 已匹配</div>
                        <div class="level-badge">${levelDisplay}</div>
                    </div>
                    ${minimizeBtnHtml} </div>

                <div class="gmv-hero">
                    <div class="hero-label">30天预估 GMV</div>
                    <div class="hero-value">$${gmvDisplay}</div>
                </div>

                <div class="gmv-grid">
                    <div class="grid-item">
                        <span class="label">主要年龄</span>
                        <span class="value">${ageDisplay}</span>
                    </div>
                    <div class="grid-item">
                        <span class="label">年龄占比</span>
                        <span class="value highlight">${ratioDisplay}</span>
                    </div>
                </div>

                <div class="bd-box">
                    <span class="bd-label">负责 BD</span>
                    <span class="bd-value">${bdDisplay}</span>
                </div>

                <div class="gmv-contact">
                    <div class="label">对接邮箱</div>
                    <div class="email-text">${contactDisplay}</div>
                </div>

                <div class="gmv-footer">UID: ${uid}</div>
            </div>
        `;
    } else {
        innerContent = `
            <div class="full-content">
                 <div class="gmv-header">
                    <div class="header-left">
                        <div class="status-badge error">❌ 未收录</div>
                    </div>
                    ${minimizeBtnHtml}
                </div>
                <div class="empty-state">
                    <div class="not-found-text">无此 UID 数据</div>
                    <div class="uid-text">UID: ${uid}</div>
                </div>
            </div>
        `;
    }

    // 拼装：小图标 + 完整内容
    div.innerHTML = `
        <div class="mini-icon">查</div>
        ${innerContent}
    `;

    document.body.appendChild(div);

    // --- 绑定交互事件 (并保存状态) ---
    const minimizeBtn = div.querySelector('#minimize-btn');
    
    // ▼▼▼▼▼ 关键点 2：点击事件中保存状态 ▼▼▼▼▼

    // 点击缩小按钮 -> 变小并记住
    if (minimizeBtn) {
        minimizeBtn.addEventListener('click', (e) => {
            e.stopPropagation(); 
            div.classList.add('minimized');
            // 存入 localStorage
            localStorage.setItem('gmvPanelMinimized', 'true');
        });
    }

    // 点击小圆球 -> 展开并记住
    div.addEventListener('click', () => {
        if (div.classList.contains('minimized')) {
            div.classList.remove('minimized');
            // 存入 localStorage
            localStorage.setItem('gmvPanelMinimized', 'false');
        }
    });
    // ▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲
}

init();